@extends('layouts.simple.master')

@section('title', 'FAQ Categories')

@section('css')
    
@endsection

@section('style')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb-title')
<h3>Add FAQ Category</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item"><a href="{{route('admin.faqs.faqs-list')}}">FAQ's</a></li>
    <li class="breadcrumb-item"><a href="{{route('admin.faqs.faq-categories')}}">FAQ Categories List</a></li>
    <li class="breadcrumb-item active">Add Category</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
	  <div class="col-sm-12">
		<div class="card">
		    <form class="form theme-form" enctype="multipart/form-data" method="post" action="{{route('admin.faqs.store-faq-category')}}">
          @csrf
          <div class="card-body">
            <div class="row">
              
              <div class="col-sm-12">
                <div class="row">
                  <div class="col-12 mb-3">
                    <label class="form-label required" for="title">Title</label>
                    <input class="form-control" id="title" required type="text" required name="title" value="{{old('title')}}">
                  </div>
                </div>
                <div class="row">
                  <div class="col-12 mb-3">
                    <label class="form-label" for="description">Description</label>
                    <textarea class="form-control" id="description" type="text" required name="description" value="{{old('description')}}"></textarea>
                  </div>
                </div>
              </div>
            </div>	
            <div class="row text-end">
              <div class="col-12">
                <button class="btn btn-primary" type="submit">Submit</button>
                <input class="btn btn-light" type="reset" value="Cancel">
              </div>
            </div>
          </div>
		    </form>
		</div>
	   </div>
	</div>
</div>
@endsection