@extends('layouts.simple.master')

@section('title', 'Disclaimer')

@section('breadcrumb-title')
    <h3>Disclaimer</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Dashboard</li>
    <li class="breadcrumb-item">CMS</li>
    <li class="breadcrumb-item active">Disclaimer</li>
@endsection

@section('script')
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
				<form class="form theme-form" method="post" enctype="multipart/form-data" action="{{route('admin.master.disclaimer.save')}}">
				    @csrf
					<div class="card-body">
						<div class="row">
                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <label class="form-label" for="title">Title</label>
                                    <input class="form-control" id="title" type="text" name="title"  value="{{ old('title') ?? ($disclaimer->title ?? '') }}" />
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <label class="form-label" for="description">Privacy</label>
                                    <textarea class="form-control btn-square" name="description" id="description" rows="5" spellcheck="true">{{ old('title') ?? ($disclaimer->description ?? '') }}</textarea>	
                                </div>
                            </div>

                            <div class="col-md-12 text-end">
                                <button class="btn btn-primary" type="submit">Save</button>
                                <input class="btn btn-light" type="reset" value="Cancel">
                            </div>
                        </div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection

@section('scripts')
    <script>
        CKEDITOR.replace( 'description', {
            customConfig: "{{asset('assets\js\editor\ckeditor\text_config.js')}}"
        });
    </script>
@endsection
