@extends('layouts.simple.master')
@section('title', 'Customers List')


@section('style')
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-title')
    <h3>Customers List</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Customers</li>
    <li class="breadcrumb-item active">Customers List</li>
@endsection

@section('content')
    <div class="container-fluid basic_table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-primary btn-sm pull-right" href="{{ route('admin.add-customer') }}"
                            data-bs-original-title="" title=""><i class="fa fa-plus"></i> Add Customer</a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table  table-striped table-bordered" id="CustomersTable">
                                <thead>
                                    <tr>
                                        <th scope="col">S.No</th>
                                        <th scope="col">ID</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Mobile No</th>
                                        <th scope="col">Question</th>
                                        <th scope="col">Answer</th>
                                        </th>
                                        <th scope="col">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($customers) > 0)
                                        @foreach ($customers as $index => $customer)
                                            @php
                                                $question = $customer->userQuestions->first();
                                            @endphp
                                            <tr>
                                                <th scope="row">{{ ++$index }}</th>
                                                <td>{{ $customer->id }}</td>
                                                <td>{{ $customer->name }}</td>
                                                <td>{{ $customer->email }}</td>
                                                <td>{{ $customer?->additional_info?->phone }}</td>
                                                <td>{{ $question->question->question ?? '' }}</td>
                                                <td>{{ $question->answer->option ?? '' }}</td>
                                                <td>
                                                    <ul class="action">
                                                        <li class="edit"><a
                                                                href="{{ route('admin.update-customer', $customer->id) }}"><i
                                                                    class="icon-pencil-alt"></i></a></li>
                                                        <li class="delete"><a onclick="return confirmDelete();"
                                                                href="{{ route('admin.delete-user', ['id' => $customer->id, 'type' => 'customer']) }}"
                                                                data-bs-original-title="" title=""><i
                                                                    class="icon-trash"></i></a></li>
                                                    </ul>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                            {!! $customers->links() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

<!-- @section('script')
    <script>
        $("#CustomersTable").DataTable();

        function confirmDelete() {
            return confirm('Are you sure you want to delete this customer?');
        }
    </script>
@endsection -->
