@extends('layouts.simple.master')
@if (isset($user))
    @section('title', 'Update Customer')
@else
    @section('title', 'Create Customer')
@endif


@section('css')
    <style>
        .avatar-preview>div {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background-size: cover;
            background-repeat: no-repeat;
            background-position: top
        }
    </style>
@endsection

@section('style')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/plugin/jquery_filer/css/jquery.filer.css') }}">
    <link href="{{ asset('assets/plugin/jquery_filer/css/themes/jquery.filer-dragdropbox-theme.css') }}" type="text/css"
        rel="stylesheet" />
@endsection

@section('breadcrumb-title')
    @if (isset($user))
        <h3>Edit Customer</h3>
    @else
        <h3>Create Customer</h3>
    @endif
@endsection

@section('breadcrumb-items')
    @if (isset($user))
        <li class="breadcrumb-item">Customers</li>
        <li class="breadcrumb-item active">Edit Customer</li>
    @else
        <li class="breadcrumb-item">Customers</li>
        <li class="breadcrumb-item active">Create Customer</li>
    @endif
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        @if (isset($user))
                            <h5>Edit Customer</h5>
                        @else
                            <h5>create Customer</h5>
                        @endif

                    </div>
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @php
                        $languages = app('bmf')->getLanguages();
                        $timezones = app('bmf')->getTimeZones();
                    @endphp
                    <form class="form theme-form" enctype="multipart/form-data" method="post"
                        action="{{ route('admin.update-info') }}">
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label required" for="first_name">First Name</label>
                                        <input type="hidden" name="id" value="{{ isset($user) ? $user?->id : '' }}" />
                                        <input class="form-control" id="first_name" type="text" required
                                            value="{{ old('first_name', isset($user) ? $user->first_name : '') }}"
                                            name="user[first_name]">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label required" for="last_name">Last Name</label>
                                        <input class="form-control" id="last_name" type="text" required
                                            value="{{ old('last_name', isset($user) ? $user->last_name : '') }}"
                                            name="user[last_name]">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="dob">DOB</label>
                                        <input class="form-control" id="dob" name="additional[dob]"
                                            value="{{ isset($user) ? $user?->additional_info?->dob : '' }}" type="date"
                                            placeholder="DOB">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="password">Address</label>
                                        <input class="form-control" name="additional[address]"
                                            value="{{ isset($user) ? $user?->additional_info?->address : '' }}"
                                            id="address" type="address">
                                    </div>
                                </div>


                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="language">Language</label>
                                        <select class="form-control" name="additional[language]">
                                            <option>Select Language</option>
                                            @foreach ($languages as $key => $language)
                                                <option value={{ $key }}
                                                    {{ isset($user) ? ($user?->additional_info?->language == $key ? 'selected' : '') : '' }}>
                                                    {{ $language }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="timezone">Timezone</label>
                                        <select class="form-control" name="additional[timezone]">
                                            <option>Select Timezone</option>
                                            @foreach ($timezones as $key => $timezone)
                                                <option value={{ $key }}
                                                    {{ isset($user) ? ($user?->additional_info?->timezone == $key ? 'selected' : '') : '' }}>
                                                    {{ $timezone }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="status">Status</label>
                                        <div class="m-checkbox-inline">
                                            <div class="radio radio-theme">
                                                <input id="active" type="radio" name="user[status]"
                                                    {{ isset($user) && $user->status == 1 ? 'checked' : '' }}
                                                    value="1" data-bs-original-title="" title="">
                                                <label for="active">Active</label>
                                            </div>
                                            <div class="radio radio-theme">
                                                <input id="inactive" type="radio" name="user[status]"
                                                    {{ isset($user) && $user->status == 0 ? 'checked' : '' }}
                                                    value="0" data-bs-original-title="" title="">
                                                <label for="inactive">Inactive</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label required" for="email">Email address</label>
                                        <input class="form-control" id="email" required name="user[email]"
                                            value="{{ old('email', isset($user) ? $user->email : '') }}" type="email"
                                            placeholder="name@example.com">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="phone">Phone</label>
                                        <input class="form-control" id="phone" name="additional[phone]"
                                            value="{{ old('phone', isset($user) ? $user?->additional_info?->phone : '') }}"
                                            type="text">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="password">Password</label>
                                        <input class="form-control" name="user[password]" id="password" type="password"
                                            placeholder="Password">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="mb-3">
                                        <label class="form-label" for="profile_pic">Profile Pic</label>
                                        <input class="form-control" name="additional[profile_pic]" type="file">
                                    </div>
                                    @if (!empty($user->additional_info->profile_pic) && Storage::exists($user?->additional_info?->profile_pic))
                                        <div class="avatar-preview">
                                            <img src="{{ asset(Storage::url($user->additional_info->profile_pic)) }}"
                                                style="width:30%;height:5%" />
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="card-footer text-end">
                            <button class="btn btn-primary" type="submit">Submit</button>
                            <input class="btn btn-light" type="reset" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
