@extends('layouts.simple.master')

@section('title', 'Update Featured Contest')

@section('breadcrumb-title')
    <h3>Edit Featured Contest</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Contest Management</li>
    <li class="breadcrumb-item active">Edit Featured Contest</li>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Edit Featured Contest</h5>
                    </div>

                    <form class="form theme-form" method="post" enctype="multipart/form-data"
                        action="{{ route('admin.update-featured') }}">
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="title">Contest Name</label>
                                        <input type="hidden" name="id" value="{{ $contest->id }}" />
                                        <input class="form-control" id="title" readonly type="text"
                                            value="{{ old('title', isset($contest) ? $contest->title : '') }}">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="m-checkbox-inline">
                                        <div class="checkbox">
                                            <input id="featured" type="checkbox"
                                                {{ isset($contest) && $contest->featured == 1 ? 'checked' : '' }}
                                                name="featured" />
                                            <label for="featured">Featured Contest</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="sort">Sort</label>
                                        <select class="form-select digits" name="sort" id="exampleFormControlSelect9"
                                            fdprocessedid="3paag">
                                            <option>Select Sort</option>
                                            <option value="1"
                                                {{ isset($contest) && $contest->sort == 1 ? 'selected' : '' }}>1</option>
                                            <option value="2"
                                                {{ isset($contest) && $contest->sort == 2 ? 'selected' : '' }}>2</option>
                                            <option value="3"
                                                {{ isset($contest) && $contest->sort == 3 ? 'selected' : '' }}>3</option>
                                            <option value="4"
                                                {{ isset($contest) && $contest->sort == 4 ? 'selected' : '' }}>4</option>
                                            <option value="5"
                                                {{ isset($contest) && $contest->sort == 5 ? 'selected' : '' }}>5</option>
                                            <option value="6"
                                                {{ isset($contest) && $contest->sort == 6 ? 'selected' : '' }}>6</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer text-end">
                            <button class="btn btn-primary" type="submit">Submit</button>
                            <input class="btn btn-light" type="reset" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
