@extends('layouts.simple.master')
@section('title', 'Contests List')

@section('css')
@endsection

@section('style')
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-title')
    <h3>Contest Management</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item active">Contest Management</li>
@endsection

@section('content')
    <div class="container-fluid basic_table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <div class="pull-right">
                            <a class="btn btn-primary btn-sm" href="{{ route('admin.create-contest') }}"
                                data-bs-original-title="" title=""><i class="fa fa-plus"></i> Add Contest</a>
                            <a class="btn btn-primary btn-sm" href="{{ route('admin.featured-contests') }}"
                                data-bs-original-title="" title="">Featured Contests</a>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered" id="contestTableList">
                                <thead>
                                    <tr>
                                        <th scope="col">Id</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Contest No</th>
                                        <th scope="col">Start Date</th>
                                        <th scope="col">End Date</th>
                                        <th scope="col">Draw Date</th>
                                        <th scope="col">Price</th>
                                        <th scope="col">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($contests) > 0)
                                        @foreach ($contests as $index => $contest)
                                            <tr>
                                                <th scope="row">{{ $contest->id }}</th>
                                                <td>{{ $contest->title }}</td>
                                                <td>{{ $contest->contest_no }}</td>
                                                <td>{{ $contest->contest_on }}</td>
                                                <td>{{ $contest->contest_end }}</td>
                                                <td>{{ $contest->draw_date }}</td>
                                                <td>{{ $contest->price }}</td>
                                                <td>
                                                    <ul class="action">
                                                        <li class="edit"> <a
                                                                href="{{ route('admin.update-contest', $contest->id) }}"
                                                                data-bs-original-title="" title=""><i
                                                                    class="icon-pencil-alt"></i></a>
                                                        </li>
                                                        <li class="delete"><a onclick="return confirmDelete();"
                                                                href="{{ route('admin.delete-contest', $contest->id) }}"
                                                                data-bs-original-title="" title=""><i
                                                                    class="icon-trash"></i></a></li>
                                                    </ul>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $("#contestTableList").DataTable();

        function confirmDelete() {
            return confirm('Are you sure you want to delete this contest?');
        }
    </script>
@endsection
