@extends('layouts.simple.master')
@section('title', 'Featured Contests List')

@section('css')
@endsection

@section('style')
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-title')
    <h3>Featured Contests</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Contest Management</li>
    <li class="breadcrumb-item active">Featured Contests</li>
@endsection

@section('content')
    <div class="container-fluid basic_table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered" id="contestList">
                                <thead>
                                    <tr>
                                        <th scope="col">Id</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Sort</th>
                                        <th scope="col">Price</th>
                                        <th scope="col">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($contests) > 0)
                                        @foreach ($contests as $index => $contest)
                                            <tr>
                                                <th scope="row">{{ $contest->id }}</th>
                                                <td>{{ $contest->title }}</td>
                                                <td>{{ $contest->sort }}</td>
                                                <td>{{ $contest->price }}</td>
                                                <td>
                                                    <ul class="action">
                                                        <li class="edit"> <a
                                                                href="{{ route('admin.edit-featured-contests', $contest->id) }}"
                                                                data-bs-original-title="" title=""><i
                                                                    class="icon-pencil-alt"></i></a>
                                                        </li>
                                                    </ul>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $("#contestList").DataTable({
            "aaSorting": [
                [0, 'desc']
            ],
            "bDestroy": true
        });
    </script>
@endsection
