@extends('layouts.simple.master')

@section('title', 'Create Contest')

@section('css')
    <style>
        .jFiler-input-dragDrop {
            width: 100% !important;
        }
    </style>
@endsection

@section('style')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/plugin/jquery_filer/css/jquery.filer.css') }}">
    <link href="{{ asset('assets/plugin/jquery_filer/css/themes/jquery.filer-dragdropbox-theme.css') }}" type="text/css"
        rel="stylesheet" />
@endsection

@section('breadcrumb-title')
    <h3>Create Contest</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Contest Management</li>
    <li class="breadcrumb-item active">Create Contest</li>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h5>create contest</h5>
                    </div>

                    <form class="form theme-form" method="post" enctype="multipart/form-data"
                        action="{{ route('admin.store-contest') }}">
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="title">Contest Name <span
                                                class="text-red">*</span></label>
                                        <input class="form-control" id="title" required type="text" name="title"
                                            value="{{ old('title', isset($contest) ? $contest->title : '') }}">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="contest_no">Contest Number <span
                                                class="text-red">*</span></label>
                                        <input class="form-control" id="contest_no" required type="text"
                                            name="contest_no"
                                            value="{{ old('contest_no', isset($contest) ? $contest->contest_no : '') }}">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="priceType">Price Type <span
                                                class="text-red">*</span></label>
                                        @php
                                            $priceTypes = app('bmf')->priceTypes();
                                        @endphp
                                        <select class="form-select digits" required name="price_type" id="priceType"
                                            fdprocessedid="3paag">
                                            <option>Select Price Type</option>
                                            @foreach ($priceTypes as $type)
                                                <option value="{{ $type }}">{{ $type }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="price">Ticket Price <span
                                                class="text-red">*</span></label>
                                        <div class="input-group"><span class="input-group-text">€</span>
                                            <input class="form-control" required id="price" type="text"
                                                name="price"
                                                value="{{ old('price', isset($contest) ? $contest->price : '') }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="qty">No of Tickets <span
                                                class="text-red">*</span></label>
                                        <input class="form-control" required id="qty" name="qty"
                                            value="{{ old('qty', isset($contest) ? $contest->qty : '') }}" type="number">
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <div class="mb-3">
                                        <label class="form-label" for="contest_on">Contest Start Date <span
                                                class="text-red">*</span></label>
                                        <input class="form-control digits" required min="<?php echo date('Y-m-d'); ?>"
                                            name="contest_on" id="contest_on" type="date">
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <div class="mb-3">
                                        <label class="form-label" for="contest_end">Contest End Date <span
                                                class="text-red">*</span></label>
                                        <input class="form-control digits" required min="<?php echo date('Y-m-d'); ?>"
                                            name="contest_end" id="contest_end" type="date">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="draw_date">Contest Draw Date <span
                                                class="text-red">*</span></label>
                                        <input class="form-control digits" required min="<?php echo date('Y-m-d'); ?>"
                                            name="draw_date" id="draw_date" type="datetime-local">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="price">Winning Amount <span
                                                class="text-red">*</span></label>
                                        <div class="input-group"><span class="input-group-text">€</span>
                                            <input class="form-control" required id="winning_amount" type="text"
                                                name="winning_amount"
                                                value="{{ old('winning_amount', isset($contest) ? $contest->winning_amount : '') }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 pt-4">
                                    <div class="m-checkbox-inline pt-1">
                                        <div class="checkbox">
                                            <input id="featured" type="checkbox" name="featured" />
                                            <label for="featured">Featured Contest</label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="price_delivery">Price Delivery </label>
                                        <input class="form-control" id="price_delivery" type="text"
                                            name="price_delivery"
                                            value="{{ old('price_delivery', isset($contest) ? $contest->price_delivery : '') }}" />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                {{-- <div class="col-sm-12">
                                    <div class="mb-3">
                                        <label class="form-label" for="description">Vehicle Overview</label>
                                        <textarea class="form-control btn-square" name="description" id="description" rows="3" spellcheck="true"></textarea>
                                    </div>
                                </div> --}}

                                <div class="col-sm-12">
                                    <div class="mb-3">
                                        <label class="form-label" for="neweditor1">Competition Details</label>
                                        <textarea class="form-control btn-square" name="competition_details" id="neweditor1" rows="3"
                                            spellcheck="true"></textarea>

                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="mb-3">
                                        <label class="form-label" for="images">Upload Images</label>
                                        <input class="form-control" name="images[]" multiple id="jfilerImages"
                                            type="file">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer text-end">
                            <button class="btn btn-primary" type="submit">Submit</button>
                            <a class="btn btn-light" href="">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function() {
            // When Contest End Date is selected
            $('#contest_end').on('change', function() {
                const endDate = new Date($(this).val()); // Get the selected End Date
                const drawDateInput = $('#draw_date');

                if (!isNaN(endDate)) {
                    const minDateTime = new Date(endDate);
                    minDateTime.setDate(minDateTime.getDate() +
                        1); // Set Draw Date to one day after the End Date

                    // Update the min attribute of Draw Date
                    drawDateInput.attr('min', minDateTime.toISOString().slice(0,
                        16)); // Format to "YYYY-MM-DDTHH:mm"

                    // Clear previously invalid draw date
                    if (drawDateInput.val() && new Date(drawDateInput.val()) <= endDate) {
                        drawDateInput.val('');
                    }
                }
            });

            // Validate Contest Draw Date
            $('#draw_date').on('change', function() {
                const endDate = new Date($('#contest_end').val());
                const drawDateTime = new Date($(this).val());
                const feedback = $('#dateFeedback');

                if (drawDateTime <= endDate) {
                    feedback.text('The draw date and time must be after the end date.');
                    feedback.show();
                    $(this).val(''); // Clear invalid input
                } else {
                    feedback.hide();
                }
            });
        });
    </script>
@endsection
