@extends('layouts.simple.master')

@section('title', 'Contact Enquiry')

@section('css')
@endsection

@section('style')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-title')
<h3>Contact Enquiry</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">CMS</li>
    <li class="breadcrumb-item active">Contact Enquiry</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-body">
            <table class="table table-striped table-bordered" id="requestsList">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Name</th>
                  <th>Email</th>
                  <th>Mobile</th>
                  <th>Country</th>
                  <th>Subject</th>
                  <th>Message</th>
                  <th>Enquiry At</th>
                </tr>
              </thead>
              <tbody>
                @foreach ($receivedRequests as $key => $value)
                  <tr>
                    <td>{{$key + 1}}</td>
                    <td>{{$value->name}} {{$value->last_name}}</td>
                    <td>{{$value->email}}</td>
                    <td>{{$value->mobile_no}}</td>
                    <td>{{$value->country}}</td>
                    <td>{{$value->subject}}</td>
                    <td>{{$value->message}}</td>
                    <td>{{date('d-M-Y H:m:s', strtotime($value->created_at))}}</td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
	</div>
</div>
@endsection

@section('script')
  <script>
    $("#requestsList").DataTable();
  </script>
@endsection
