@extends('layouts.simple.master')

@section('title', 'Contact Master Data')

@section('css')

@endsection

@section('style')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb-title')
<h3>Contact Page: Master Data</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Contact Us</li>
    <li class="breadcrumb-item">Master Data</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
	  <div class="col-sm-12">
		<div class="card">
		    <form class="form theme-form" enctype="multipart/form-data" method="post" action="{{route('admin.contact_us.dynamic.store')}}">
                @csrf
                <div class="card-body">
                    <div class="row">

                        <div class="col-sm-12">
                            <div class="mb-3">
                                <label class="form-label" for="title">Title</label>
                                <input class="form-control" id="title" type="text" required name="title" value="{{$contactPage->title ?? ''}}" >
                            </div>
                        </div>

                        <div class="col-sm-12">
                            <div class="mb-3">
                                <label class="form-label" for="description">Description</label>
                                <textarea class="form-control" id="description" required rows="3" name="description">{!! $contactPage->description ?? '' !!}</textarea>
                            </div>
                        </div>

                        @if(!isset($contactPage->image))
                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <label class="form-label" for="image">Image</label>
                                    <input class="form-control" id="image" type="file" required name="image" accept=".png, .jpg, .jpeg, .svg">
                                </div>
                            </div>
                        @else
                            <div class="col-sm-12 mb-3">
                                <div class="row d-flex align-items-center">

                                    <div class="{{(!empty($contactPage->image) && Storage::exists($contactPage->image))?'col-10':'col-12' }}">
                                        <label class="form-label" for="image">Image <span class="text-red">{{(!empty($contactPage->image) && Storage::exists($contactPage->image))?'':'*' }}</span></label>

                                        <input class="form-control" type="file" accept=".png, .jpg, .jpeg, .svg" name="image" {{(!empty($contactPage->image) && Storage::exists($contactPage->image))?:'required' }}  />
                                    </div>
                                    @if(!empty($contactPage->image) && Storage::exists($contactPage->image))
                                        <div class="col-2 p-0">
                                            <a href="{{asset(Storage::url($contactPage->image))}}" target="_blank">
                                                <img src="{{asset(Storage::url($contactPage->image))}}" style="width:100px;" alt="{{$contactPage->title}}" />
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif

                        <div class="col-sm-12">
                            <div class="row">
                                <div class="col-6 mb-3">
                                    <label class="form-label" for="phone">Phone Number</label>
                                    <input class="form-control" id="phone" type="text" required name="phone" value="{{$contactPagePhone->value ?? ''}}">
                                </div>

                                <div class="col-6 mb-3">
                                    <label class="form-label" for="email">Email</label>
                                    <input class="form-control" id="email" type="email" required name="email" value="{{$contactPageEmail->value ?? ''}}">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row text-end">
                        <div class="col-12">
                            <button class="btn btn-primary" type="submit">Submit</button>
                            <input class="btn btn-light" type="reset" value="Cancel">
                        </div>
                    </div>
                </div>
		    </form>
		</div>
	   </div>
	</div>
</div>
@endsection

@section('script')

@endsection
