@extends('layouts.simple.master')
@section('title', 'CategoryList')


@section('breadcrumb-title')
    <h3>Category List</h3>
@endsection
@section('css')

@endsection
@section('breadcrumb-items')
    <li class="breadcrumb-item">Category</li>
    <li class="breadcrumb-item active">Category List</li>
@endsection
<style>
    .table-dark .border{
    background: #33B9EA !important;
    }
    .dt-search{
        float:right;
    }
    svg.w-5.h-5 {
    width: 20px !important;
    height: 20px !important;
    display: none;
}

span.relative.z-0 {
    display: flex;
    justify-content: flex-end;
    align-content: center;
    align-items: center;
    flex-wrap: nowrap;
    display: none;

}
</style>
@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <a class="btn btn-primary btn-sm float-end" href="{{ route('admin.add-category') }}">
                <i class="fa fa-plus"></i> Add Category
            </a>
        </div>
        <div class="card-body">
        <div class="table-responsive">
        <table class="table  table-striped table-bordered " id="NewsTable">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Category</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @if ($category->count() > 0)
                @foreach ($category as $index => $item)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $item->category_name }}</td>
                        <td>
                        <ul class="action">
                        <li class="edit">
                            <a href="{{ route('admin.edit-category', $item->id) }}">
                                <i class="icon-pencil-alt"></i>
                            </a>
                        </li>   
                        </ul>
                        </td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="3" class="text-center text-muted">No Categories Found</td>
                </tr>
            @endif
        </tbody>

    </table>

    @if($category->isEmpty())
        <div class="alert alert-warning text-center">No categories available. Add a new category.</div>
    @else
    <div class="flex justify-center mt-4">
        {!! $category->links() !!}
</div>
    @endif
</div>
</div>
</div>
</div>

<script>
    // function confirmDelete() {
    //     return confirm('Are you sure you want to delete this news item?');
    // }
</script>
@endsection


