@extends('layouts.simple.master')

@section('title', 'Contact Master Data')

@section('css')
    
@endsection

@section('style')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-title')
<h3>Testimonials</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">CMS</li>
    <li class="breadcrumb-item">Testimonials</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
	  <div class="col-sm-12">
      <div class="card">
        <div class="card-header">
          <div class="row">
            <div class="col-6">
              <!--<h5>Testimonials</h5>-->
            </div>
            <div class="col-6">
              <a href="{{route('admin.about_us.testimonial.create')}}" class="btn btn-primary btn-sm float-end pull-right">Create Testimonials</a>
            </div>
          </div>
        </div>
          <div class="card-body">
              <table class="table table-striped table-bordered" id="testimonialsList">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Image</th>
                    <th>Name</th>
                    <th>Rating</th>
                    <th>Description</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($testimonials as $key => $testimonial)
                    <tr>
                      <td>{{$key + 1}}</td>
                      <td>
                        @if(!empty($testimonial->image) && Storage::exists($testimonial->image))
                          <div class="col-1 p-0">
                            <a href="{{asset(Storage::url($testimonial->image))}}" target="_blank">
                                <img src="{{asset(Storage::url($testimonial->image))}}" style="width:150px;height:150px;object-fit:cover;" alt="{{$testimonial->title}}" />
                            </a>
                          </div>
                        @endif
                      </td>
                      <td>{{$testimonial->name}}</td>
                      <td>{{$testimonial->value}}</td>
                      <td>{{$testimonial->description}}</td>
                      <td>
                        <div>
                          <ul class="action">
                            <li class="edit"><a href="{{route('admin.about_us.testimonial.edit', ['id'=>$testimonial->id])}}" class="btn-link"><i class="icon-pencil-alt"></i></a></li>
                            <li class="delete"><a onclick="return confirmDelete();" href="{{route('admin.about_us.testimonial.delete', ['id'=>$testimonial->id])}}" class="btn-link"><i class="icon-trash"></i></a></li>
                          </ul>
                        </div>
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
      </div>
	   </div>
	</div>
</div>
@endsection

@section('script')
  <script>
    $("#testimonialsList").DataTable();
    function confirmDelete(){
      return confirm('Are you sure you want to delete this testimonial?');
    }
  </script>
@endsection
