@extends('layouts.simple.master')

@section('title', 'Edit Testimonial')

@section('css')

@endsection

@section('style')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb-title')
<h3>Testimonial Edit</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">About Us</li>
    <li class="breadcrumb-item">Testimonials</li>
    <li class="breadcrumb-item active">Edit New</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
	  <div class="col-sm-12">
		<div class="card">
		    <form class="form theme-form" enctype="multipart/form-data" method="post" action="{{route('admin.about_us.testimonial.update', ['id' => $testimonial->id])}}">
                @csrf
                <div class="card-body">
                  <div class="row">
                    <div class="col-sm-12">
                      <div class="row">
                        <div class="col-6 mb-3">
                          <label class="form-label" for="name">Name</label>
                          <input class="form-control" id="name" type="text" required name="name" value="{{old('name') ?? $testimonial->name}}">
                        </div>

                        <div class="col-6 mb-3">
                          <label class="form-label" for="value">Rate</label>
                          <input class="form-control" id="value" type="text" min="1" max="5" required name="value" value="{{old('value') ?? $testimonial->value}}">
                        </div>
                      </div>
                  </div>

                    @if(!isset($testimonial->image))
                        <div class="col-sm-12">
                            <div class="mb-3">
                                <label class="form-label" for="image">Image</label>
                                <input class="form-control" id="image" type="file" required name="image" accept=".png, .jpg, .jpeg, .svg">
                            </div>
                        </div>
                    @else
                        <div class="col-md-12 mb-3">
                            <div class="row d-flex align-items-center">
                                <div class="{{(!empty($testimonial->image) && Storage::exists($testimonial->image))?'col-10':'col-12' }}">
                                    <label class="form-label" for="image">Image <span class="text-red">{{(!empty($testimonial->image) && Storage::exists($testimonial->image))?'':'*' }}</span></label>
                                    <input class="form-control" type="file" accept=".png, .jpg, .jpeg, .svg" name="image" {{(!empty($testimonial->image) && Storage::exists($testimonial->image))?:'required' }}  />
                                </div>
                                @if(!empty($testimonial->image) && Storage::exists($testimonial->image))
                                    <div class="col-2 p-0">
                                        <a href="{{asset(Storage::url($testimonial->image))}}" target="_blank">
                                            <img src="{{asset(Storage::url($testimonial->image))}}" style="width:100px;" alt="{{$testimonial->name}}" />
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif

                  <div class="col-sm-12">
                    <div class="mb-3">
                      <label class="form-label" for="description">Description</label>
                      <textarea class="form-control" id="description" required rows="3" name="description">{{old('description') ?? $testimonial->description}}</textarea>
                    </div>
                  </div>

                </div>
                    <div class="row text-end">
                      <div class="col-12">
                        <button class="btn btn-primary" type="submit">Update</button>
                        <input class="btn btn-light" type="reset" value="Cancel">
                      </div>
                    </div>
                </div>
		    </form>
		</div>
	   </div>
	</div>
</div>
@endsection

@section('script')

@endsection
