@extends('layouts.simple.master')

@section('title', 'Contact Master Data')

@section('css')
    
@endsection

@section('style')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb-title')
<h3>Testimonials Create</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">About Us</li>
    <li class="breadcrumb-item">Testimonials</li>
    <li class="breadcrumb-item active">Add New</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
	  <div class="col-sm-12">
		<div class="card">
		    <form class="form theme-form" enctype="multipart/form-data" method="post" action="{{route('admin.about_us.testimonial.store')}}">
                @csrf
                <div class="card-body">
                  <div class="row">
                    <div class="col-sm-12">
                      <div class="row">
                        <div class="col-6 mb-3">
                          <label class="form-label" for="name">Name</label>
                          <input class="form-control" id="name" type="text" required name="name" value="{{old('name')}}">
                        </div>

                        <div class="col-6 mb-3">
                          <label class="form-label" for="value">Rate</label>
                          <input class="form-control" min="1" max="5" id="value" type="text" required name="value" value="{{old('value')}}">
                        </div>
                      </div>
                  </div>

                  <div class="col-sm-12">
                    <div class="mb-3">
                      <label class="form-label" for="image">Image</label>
                      <input class="form-control" id="image" type="file" required name="image" accept=".png, .jpg, .jpeg, .svg">
                    </div>
                  </div>

                  <div class="col-sm-12">
                    <div class="mb-3">
                      <label class="form-label" for="description">Description</label>
                      <textarea class="form-control" id="description" required rows="3" name="description"></textarea>
                    </div>
                  </div>
                  
                </div>	
                
                    <div class="row text-end">
                      <div class="col-12">
                        <button class="btn btn-primary" type="submit">Submit</button>
                        <input class="btn btn-light" type="reset" value="Cancel">
                      </div>
                    </div>
                </div>
		    </form>
		</div>
	   </div>
	</div>
</div>
@endsection

@section('script')

@endsection
