@extends('layouts.simple.master')

@section('title', 'Team Members')

@section('css')
    
@endsection

@section('style')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-title')
<h3>Team Members</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">About Us</li>
    <li class="breadcrumb-item">Team Members</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
	  <div class="col-sm-12">
      <div class="card">
          <div class="card-header">
            <div class="row">
              <div class="col-6">
                <!--<h5>Team Members</h5>-->
              </div>
              <div class="col-6">
                <a href="{{route('admin.about_us.team.create')}}" class="btn btn-primary btn-sm float-end pull-right">Create Team Member</a>
              </div>
            </div>
          </div>
          <div class="card-body">
              <table class="table table-striped table-bordered" id="teamList">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Image</th>
                    <th>Name</th>
                    <th>Degination</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($teamMembers as $key => $teamMember)
                    <tr>
                      <td>{{$key + 1}}</td>
                      <td>
                        @if(!empty($teamMember->image) && Storage::exists($teamMember->image))
                          <div class="col-1 p-0">
                            <a href="{{asset(Storage::url($teamMember->image))}}" target="_blank">
                              <img src="{{asset(Storage::url($teamMember->image))}}" style="width:150px;height:150px;object-fit:cover;" alt="{{$teamMember->name}}" />
                            </a>
                          </div>
                        @endif
                      </td>
                      <td>{{$teamMember->name}}</td>
                      <td>{{$teamMember->title}}</td>
                      <td>
                        <div>
                          <ul class="action">
                            <li class="edit"><a href="{{route('admin.about_us.team.edit', ['id'=>$teamMember->id])}}" class="btn-link"><i class="icon-pencil-alt"></i></a></li>
                            <li class="delete"><a onclick="return confirmDelete();" href="{{route('admin.about_us.team.delete', ['id'=>$teamMember->id])}}" class="btn-link"><i class="icon-trash"></i></a></li>
                          </ul>
                        </div>
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
      </div>
	   </div>
	</div>
</div>
@endsection

@section('script')
  <script>
    $("#teamList").DataTable();
    function confirmDelete(){
      return confirm('Are you sure you want to delete this?');
    }
  </script>
@endsection
