@extends('layouts.simple.master')

@section('title', 'Edit Testimonial')

@section('css')

@endsection

@section('style')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb-title')
<h3>Team Member Edit</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">About Us</li>
    <li class="breadcrumb-item">Team Members</li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
	  <div class="col-sm-12">
		<div class="card">
		    <form class="form theme-form" enctype="multipart/form-data" method="post" action="{{route('admin.about_us.team.update', ['id' => $team->id])}}">
                @csrf
                <div class="card-body">
                  <div class="row">
                    <div class="col-sm-12">
                      <div class="row">
                        <div class="col-6 mb-3">
                          <label class="form-label" for="name">Name</label>
                          <input class="form-control" id="name" type="text" required name="name" value="{{old('name') ?? $team->name}}">
                        </div>

                        <div class="col-6 mb-3">
                          <label class="form-label" for="title">Degination</label>
                          <input class="form-control" id="title" type="text" required name="title" value="{{old('title') ?? $team->title}}">
                        </div>
                      </div>
                  </div>

                    @if(!isset($team->image))
                        <div class="col-sm-12">
                            <div class="mb-3">
                                <label class="form-label" for="image">Image</label>
                                <input class="form-control" id="image" type="file" required name="image" accept=".png, .jpg, .jpeg, .svg">
                            </div>
                        </div>
                    @else
                        <div class="col-md-12 mb-3">
                            <div class="row d-flex align-items-center">
                                <div class="{{(!empty($team->image) && Storage::exists($team->image))?'col-10':'col-12' }}">
                                    <label class="form-label" for="image">Image <span class="text-red">{{(!empty($team->image) && Storage::exists($team->image))?'':'*' }}</span></label>

                                    <input class="form-control" type="file" accept=".png, .jpg, .jpeg, .svg" name="image" {{(!empty($team->image) && Storage::exists($team->image))?:'required' }}  />
                                </div>
                                @if(!empty($team->image) && Storage::exists($team->image))
                                    <div class="col-2 p-0">
                                        <a href="{{asset(Storage::url($team->image))}}" target="_blank">
                                            <img src="{{asset(Storage::url($team->image))}}" style="width:100px;" alt="{{$team->name}}" />
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif

                </div>
                    <div class="row text-end">
                      <div class="col-12">
                        <button class="btn btn-primary" type="submit">Update</button>
                        <input class="btn btn-light" type="reset" value="Cancel">
                      </div>
                    </div>
                </div>
		    </form>
		</div>
	   </div>
	</div>
</div>
@endsection

@section('script')

@endsection
