@extends('layouts.simple.master')

@section('title', 'Team Members')

@section('css')
    
@endsection

@section('style')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb-title')
<h3>Add Team Member</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">About Us</li>
    <li class="breadcrumb-item">Team Members</li>
    <li class="breadcrumb-item active">Add New</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
	  <div class="col-sm-12">
		<div class="card">
		    <form class="form theme-form" enctype="multipart/form-data" method="post" action="{{route('admin.about_us.team.store')}}">
          @csrf
          <div class="card-body">
            <div class="row">
              
              <div class="col-sm-12">
                <div class="row">
                  <div class="col-6 mb-3">
                    <label class="form-label" for="name">Name</label>
                    <input class="form-control" id="name" type="text" required name="name" value="{{old('name')}}">
                  </div>

                  <div class="col-6 mb-3">
                    <label class="form-label" for="title">Degination</label>
                    <input class="form-control" id="title" type="text" required name="title" value="{{old('title')}}">
                  </div>
                </div>
              </div>

              <div class="col-sm-12">
                <div class="mb-3">
                  <label class="form-label" for="image">Image</label>
                  <input class="form-control" id="image" type="file" required name="image" accept=".png, .jpg, .jpeg, .svg">
                </div>
              </div>
            
            </div>	
          
            <div class="row text-end">
              <div class="col-12">
                <button class="btn btn-primary" type="submit">Submit</button>
                <input class="btn btn-light" type="reset" value="Cancel">
              </div>
            </div>
          </div>
		    </form>
		</div>
	   </div>
	</div>
</div>
@endsection

@section('script')

@endsection
