<div class="row mb-3">

    <div class="col-sm-12">
        <h4>What makes Different?</h4>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="whatDiffernetTitle">First Title</label>
            <input class="form-control" id="whatDiffernetTitle" value="{{$aboutUsWhatsDiffIntro->title ?? ''}}" type="text" required name="whats_different_intro[title]" />
        </div>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="whatDiffernetSubTitle">Second Title</label>
            <input class="form-control" id="whatDiffernetSubTitle" value="{{$aboutUsWhatsDiffIntro->sub_title ?? ''}}" type="text" required name="whats_different_intro[sub_title]" />
        </div>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="whatDiffernetDescription">Description</label>
            <textarea class="form-control" id="whatDiffernetDescription" required rows="4" name="whats_different_intro[description]">{{$aboutUsWhatsDiffIntro->description ?? ''}}</textarea>
        </div>
    </div>

    @if(!isset($aboutUsWhatsDiffIntro->image))
        <div class="col-sm-12">
            <div class="mb-3">
                <label class="form-label" for="whatDiffernetImage">Image</label>
                <input class="form-control" id="whatDiffernetImage" type="file" required name="whats_different_intro[image]" accept=".png, .jpg, .jpeg, .svg">
            </div>
        </div>
    @else
        <div class="col-md-12">
            <div class="row mb-3 d-flex align-items-center">
                <div class="{{(!empty($aboutUsWhatsDiffIntro->image) && Storage::exists($aboutUsWhatsDiffIntro->image))?'col-10':'col-12' }}">
                    <label class="form-label" for="whatDiffernetImage">Image <span class="text-red">{{(!empty($aboutUsWhatsDiffIntro->image) && Storage::exists($aboutUsWhatsDiffIntro->image))?'':'*' }}</span></label>

                    <input class="form-control" id="whatDiffernetImage" type="file" accept=".png, .jpg, .jpeg, .svg" name="whats_different_intro[image]" {{(!empty($aboutUsWhatsDiffIntro->image) && Storage::exists($aboutUsWhatsDiffIntro->image))?:'required' }}  />
                </div>
                @if(!empty($aboutUsWhatsDiffIntro->image) && Storage::exists($aboutUsWhatsDiffIntro->image))
                    <div class="col-2 p-0">
                        <a href="{{asset(Storage::url($aboutUsWhatsDiffIntro->image))}}" target="_blank">
                            <img src="{{asset(Storage::url($aboutUsWhatsDiffIntro->image))}}" style="width:100px;" alt="{{$aboutUsWhatsDiffIntro->title}}" />
                        </a>
                    </div>
                @endif
            </div>
        </div>
    @endif

    <div class="col-sm-12">

        <h6>Steps.</h6>

        @for ($i=1; $i <= 6; $i++)
            @php
                $htpData = $aboutUsWhatsDiffIntro->moreRelatedData[$i - 1] ?? [];
            @endphp
            <div class="row mb-3">
                <div class="mb-1 col-12">
                    <label class="form-label" for="whatsdifferentStepTitle{{$i}}">Title</label>
                    <input class="form-control" id="whatsdifferentStepTitle{{$i}}" type="text" required name="whats_different[steps][{{$i}}][title]" value="{{$htpData->title ?? ''}}" >
                </div>

                <input type="hidden" name="whats_different[steps][{{$i}}][sub_title]" value="{{$htpData->sub_title ?? ''}}" />

                @if(!isset($htpData->image))
                    <div class="mb-1">
                        <label class="form-label" for="whatsdifferentStepImage{{$i}}">Image</label>
                        <input class="form-control" id="whatsdifferentStepImage{{$i}}" type="file" required name="whats_different[steps][{{$i}}][image]" accept=".png, .jpg, .jpeg, .svg">
                    </div>
                @else
                    <div class="mb-1 mt-3">
                        <div class="row d-flex align-items-center">
                            <div class="{{(!empty($htpData->image) && Storage::exists($htpData->image))?'col-10':'col-12' }}">
                                <label class="form-label" for="whatsdifferentStepImage{{$i}}">Image <span class="text-red">{{(!empty($htpData->image) && Storage::exists($htpData->image))?'':'*' }}</span></label>
                                <input class="form-control" id="howToPlayImage{{$i}}" type="file" accept=".png, .jpg, .jpeg, .svg" name="whats_different[steps][{{$i}}][image]" {{(!empty($htpData->image) && Storage::exists($htpData->image))?:'required' }}  />
                            </div>
                            @if(!empty($htpData->image) && Storage::exists($htpData->image))
                                <div class="col-2 p-0">
                                    <a href="{{asset(Storage::url($htpData->image))}}" target="_blank">
                                        <img src="{{asset(Storage::url($htpData->image))}}" style="width:100px;" alt="{{$htpData->title}}" />
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        @endfor
    </div>
</div>
