(function ($) {
    ("use strict");

    // Function to validate if the DOB is 18 years or older
    function isAgeValid(dob) {
        const birthDate = new Date(dob);
        const today = new Date();

        // Calculate age
        const age = today.getFullYear() - birthDate.getFullYear();
        const monthDifference = today.getMonth() - birthDate.getMonth();
        const dayDifference = today.getDate() - birthDate.getDate();

        // Adjust age based on the month and day differences
        if (
            monthDifference < 0 ||
            (monthDifference === 0 && dayDifference < 0)
        ) {
            return age - 1 >= 18;
        }
        return age >= 18;
    }

    // Validate DOB on form submission
    // document.getElementById("dob").addEventListener("blur", function () {
    //     const dobInput = this.value;
    //     if (!checkDOBValidOrNot(dobInput)) {
    //         $("#dobFeedback").text("You must be at least 18 years old!").show();
    //     }
    // });

    // function checkDOBValidOrNot(dobInput) {
    //     const dobFeedback = document.getElementById("dobFeedback");
    //     const dobElement = document.getElementById("dob");

    //     if (isAgeValid(dobInput)) {
    //         // Valid DOB
    //         dobElement.classList.remove("is-invalid");
    //         dobElement.classList.add("is-valid");
    //         dobFeedback.textContent = "Valid date of birth.";
    //         dobFeedback.classList.remove("text-danger");
    //         dobFeedback.classList.add("text-success");
    //     } else {
    //         // Invalid DOB
    //         dobElement.classList.remove("is-valid");
    //         dobElement.classList.add("is-invalid");
    //         dobFeedback.textContent = "You must be 18 years or older.";
    //         dobFeedback.classList.remove("text-success");
    //         dobFeedback.classList.add("text-danger");
    //     }

    //     // Show feedback and hide it after 5 seconds
    //     dobFeedback.style.display = "block";
    //     setTimeout(() => {
    //         dobFeedback.style.display = "none";
    //     }, 5000);
    //     return;
    // }

    function checkDOBValidOrNot(inputDate) {
        const [day, month, year] = inputDate.split("/").map(Number);
        const enteredDate = new Date(year, month - 1, day); // Month is zero-indexed
        const currentDate = new Date();

        // Calculate the date 18 years ago
        const eighteenYearsAgo = new Date();
        eighteenYearsAgo.setFullYear(currentDate.getFullYear() - 18);

        return enteredDate <= eighteenYearsAgo;
    }

    $("#termsCheckbox").change(function () {
        toggleSubmitButton();
    });

    $("#ageConfirmation").change(function () {
        toggleSubmitButton();
    });

    toggleSubmitButton();

    function toggleSubmitButton() {
        // Check if the checkbox is checked
        if (
            $("#termsCheckbox").is(":checked") &&
            $("#ageConfirmation").is(":checked")
        ) {
            $("#registerButton").prop("disabled", false); // Enable button
        } else {
            $("#registerButton").prop("disabled", true); // Disable button
        }
    }

    jQuery(document).ready(function ($) {
        $(document).on("submit", "#bmi_Register_New_Account", function (e) {
            e.preventDefault();

            let isValid = true;
            var statusOn = $("#registerNewUser #registerStatusMessage");

            const emailField = document.getElementById("email");
            const emailPattern =
                /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
            if (!emailPattern.test(emailField.value)) {
                e.preventDefault();
                statusOn.prepend(
                    $(
                        '<div class="alert alert-danger mt-4"><a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a> Please enter a valid email address.</div>'
                    )
                        .hide()
                        .fadeIn(1000)
                        .delay(3000) // Wait for 3 seconds
                        .fadeOut(1500, function () {
                            $(this).remove(); // Remove the element from DOM after fading out
                        })
                );
                isValid = false;
                return;
            }

            // Validate each field
            $("#bmi_Register_New_Account")
                .find("input[required]")
                .each(function () {
                    if (!$(this).val()) {
                        isValid = false;
                        $(this).addClass("is-invalid");
                    } else {
                        $(this).removeClass("is-invalid").addClass("is-valid");
                    }
                });

            // Password match validation
            if ($("#reg_password").val() !== $("#reg_confirm_password").val()) {
                isValid = false;
                $("#reg_confirm_password").addClass("is-invalid");
                statusOn.prepend(
                    '<div class="alert alert-danger mt-1 alert-dismissible"><a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a> Password and confirm password not matching.</div>'
                );
                setInterval(() => {
                    statusOn.empty();
                }, 5000);
                return;
            } else {
                $("#reg_confirm_password")
                    .removeClass("is-invalid")
                    .addClass("is-valid");
            }

            // Age validation
            if (!checkDOBValidOrNot($("#dob").val())) {
                isValid = false;
                $("#dob").addClass("is-invalid");
                statusOn.prepend(
                    $(
                        '<div class="alert alert-danger mt-4 email-success"><a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a> You must be 18 years or older.</div>'
                    )
                        .hide()
                        .fadeIn(1000)
                        .delay(3000) // Wait for 3 seconds
                        .fadeOut(1500, function () {
                            $(this).remove(); // Remove the element from DOM after fading out
                        })
                );
            } else {
                $("#dob").removeClass("is-invalid").addClass("is-valid");
            }

            $("#registerButton")
                .text("Creating account wait...")
                .attr("disabled", "disabled");
            let registerUrl = $(this).attr("action");
            let formData = $(this).serialize();

            statusOn.html("");

            if (isValid) {
                $.ajax({
                    type: "POST",
                    url: registerUrl,
                    data: formData,
                    success: function (data) {
                        console.log(data);
                        if (data.status === true) {
                            $("#bmi_Register_New_Account").trigger("reset");

                            $("#signUpModal").modal("hide"); // Close the signUpModal
                            $("#signUpModal").on(
                                "hidden.bs.modal",
                                function () {
                                    $("#signUpSuccessModal").modal({
                                        show: true,
                                        backdrop: "static",
                                        keyboard: false,
                                    });
                                }
                            );
                        } else {
                            statusOn.prepend(
                                $(
                                    '<div class="alert mt-1 alert-danger alert-dismissible">' +
                                        '<a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>' +
                                        data.message +
                                        "</div>"
                                )
                                    .hide()
                                    .fadeIn(1000)
                                    .delay(3000) // Wait for 3 seconds
                                    .fadeOut(1500, function () {
                                        $(this).remove(); // Remove the element from DOM after fading out
                                    })
                            );
                        }
                        $("#registerButton")
                            .text("Create account")
                            .removeAttr("disabled");
                        setInterval(() => {
                            // statusOn.empty();
                        }, 5000);
                        return;
                    },
                    error: function (err) {
                        console.log(err);
                        statusOn.prepend(
                            '<div class="alert mt-1 alert-danger"><a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a> Sorry, Something wrong. try again later.</div>'
                        );
                        $("#registerButton")
                            .text("Create account")
                            .removeAttr("disabled");
                        setInterval(() => {
                            // statusOn.empty();
                        }, 5000);
                        return;
                    },
                });

                return;
            }

            statusOn.prepend(
                $(
                    '<div class="alert alert-danger mt-4 email-success"><a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a> All fields are required with proper valid values.</div>'
                )
                    .hide()
                    .fadeIn(1000)
                    .delay(3000) // Wait for 3 seconds
                    .fadeOut(1500, function () {
                        $(this).remove(); // Remove the element from DOM after fading out
                    })
            );
            $("#registerButton").text("Create account").removeAttr("disabled");
            return;
        });
    });

    $("#signupUopUpModal .close-btn").on("click", function () {
        $("#signupUopUpModal").modal("hide"); // Close the modal
        window.location.href = $("#userDashboard").val(); // Redirect to userDashboard
    });

    const input = document.querySelector("#full_number");
    var iti = window.intlTelInput(input, {
        initialCountry: $("#initialCountry").val(),
        separateDialCode: false,
        utilsScript:
            "https://cdn.jsdelivr.net/npm/intl-tel-input@23.1.0/build/js/utils.js",
    });

    $("#full_number").on("blur", function () {
        // You can also set this value in another element or use it as needed
        changeDialCode();
    });

    changeDialCode();

    function changeDialCode() {
        var completeNumber = iti.getNumber();
        const countryData = iti.getSelectedCountryData();
        const countryCode = countryData.dialCode;
        const countryName = countryData.name;
        $("#country").val(countryName);
        $("#country_iso").val(countryData.iso2);
        $("#country_code").val(countryCode);
        $("#phone_number").val(completeNumber);
        $("#mobile").val(completeNumber);
    }

    $("#full_number, #postal_code").on("input", function () {
        // const $feedback = $("#numericFeedback");

        // Replace non-numeric characters
        $(this).val(
            $(this)
                .val()
                .replace(/[^0-9]/g, "")
        );

        // // Display feedback if invalid input was removed
        // if ($(this).val() === "") {
        //     $feedback.show().text("Only numbers are allowed.");
        // } else {
        //     $feedback.hide();
        // }
    });
})(jQuery);
