(function ($) {
    "use strict";

    jQuery(document).ready(function ($) {
        $(document).on("submit", "#bmi_login_Account", function (e) {
            e.preventDefault();

            let loginUrl = $(this).attr("action");
            let formData = $(this).serialize();
            var statusOn = $("#loginUser #loginStatusMessage");

            var login_email = $("#login_email").val();
            var login_password = $("#login_password").val();

            statusOn.html("");
            if (login_email && login_password) {
                $.ajax({
                    type: "POST",
                    url: loginUrl,
                    data: formData,
                    success: function (data) {
                        console.log(data);
                        if (data.status === true) {
                            statusOn.prepend(
                                '<div class="alert mt-1 alert-success alert-dismissible">' +
                                    '<a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>' +
                                    data.message +
                                    "</div>"
                            );
                            $("#bmi_login_Account").trigger("reset");
                            if (data.redirect) {
                                setInterval(() => {
                                    window.location = data.redirect;
                                }, 2500);
                            }
                            location.reload();
                        } else {
                            statusOn.prepend(
                                '<div class="alert mt-1 alert-danger alert-dismissible">' +
                                    '<a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>' +
                                    data.message +
                                    "</div>"
                            );
                        }
                        setInterval(() => {
                            // statusOn.empty();
                        }, 5000);
                        return;
                    },
                    error: function (err) {
                        console.log(err);
                        statusOn.prepend(
                            '<div class="alert mt-1 alert-danger alert-dismissible"> <a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a> Sorry, Something wrong. try again later.</div>'
                        );
                        setInterval(() => {
                            // statusOn.empty();
                        }, 5000);
                        return;
                    },
                });
            } else {
                statusOn.prepend(
                    '<div class="alert alert-danger mt-4 email-success alert-dismissible"><a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a> All fields are required.</div>'
                );
                setInterval(() => {
                    // statusOn.empty();
                }, 5000);
                return;
            }
        });
    });
})(jQuery);
