(function ($) {
    "use strict";

    jQuery(document).ready(function ($) {
        $(document).on("submit", "#bmi_forget_password", function (e) {
            e.preventDefault();

            let forgetPasswordUrl = $(this).attr("action");
            let formData = $(this).serialize();
            var statusOn = $(
                "#forgetPasswordUser #forgetPasswordStatusMessage"
            );

            var email = $("#forgetRegEmail").val();
            statusOn.html("");

            if (email) {
                $.ajax({
                    type: "POST",
                    url: forgetPasswordUrl,
                    data: formData,
                    success: function (data) {
                        console.log(data);
                        if (data.status === true) {
                            statusOn.prepend(
                                '<div class="alert mt-1 alert-success">' +
                                    '<a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>' +
                                    data.message +
                                    "</div>"
                            );
                            $("#bmi_login_Account").trigger("reset");
                            if (data.redirect) {
                                setInterval(() => {
                                    window.location = data.redirect;
                                }, 2500);
                            }
                        } else {
                            statusOn.prepend(
                                '<div class="alert mt-1 alert-danger">' +
                                    '<a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>' +
                                    data.message +
                                    "</div>"
                            );
                        }
                        setInterval(() => {
                            // statusOn.empty();
                        }, 5000);
                        return;
                    },
                    error: function (err) {
                        console.log(err);
                        statusOn.prepend(
                            '<div class="alert mt-1 alert-danger"> <a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a> Sorry, Something wrong. try again later.</div>'
                        );
                        setInterval(() => {
                            // statusOn.empty();
                        }, 5000);
                        return;
                    },
                });
            } else {
                statusOn.prepend(
                    '<div class="alert alert-danger mt-4 email-success"><a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a> All fields are required.</div>'
                );
                setInterval(() => {
                    // statusOn.empty();
                }, 5000);
                return;
            }
        });
    });
})(jQuery);
