(function ($) {
    "use strict";

    jQuery(document).ready(function ($) {
        $(document).on("submit", "#contact_form_submit", function (e) {
            e.preventDefault();
            var name = $("#name").val();
            var email = $("#email").val();
            var subject = $("#subject").val();
            var message = $("#message").val();
            var last_name = $("#last_name").val();
            var mobile_no = $("#mobile_no").val();
            var country = $("#country").val();

            if (name && email && subject && message && last_name && mobile_no && country) {
                $.ajax({
                    type: "POST",
                    url: $("#formSubmitURL").val(),
                    data: {
                        name: name,
                        email: email,
                        subject: subject,
                        message: message,
                        last_name: last_name,
                        mobile_no: mobile_no,
                        country: country,
                    },
                    success: function (data) {
                        if (data.status == true) {
                            $("#name").val("");
                            $("#email").val("");
                            $("#subject").val("");
                            $("#message").val("");
                            $("#last_name").val("");
                            $("#full_number").val("");
                            $("#country").val("");

                            //itiNumber.setNumber(''); 
                            //itiNumber.reset();

                            $("#contact_form_submit #statusMessage")
                                .children(".email-success")
                                .remove();
                            $("#contact_form_submit #statusMessage").prepend(
                                '<div class="alert mt-4 alert-success email-success">' +
                                    data.message +
                                    "</div>"
                            );
                        } else {
                            $("#contact_form_submit #statusMessage")
                                .children(".email-success")
                                .remove();
                            $("#contact_form_submit #statusMessage").prepend(
                                '<div class="alert mt-4 alert-danger email-success">' +
                                    data.message +
                                    "</div>"
                            );
                        }

                        $("#map").height("576px");
                        $(".email-success").fadeOut(8000);
                    },
                    error: function (res) {},
                });
            } else {
                $("#contact_form_submit #statusMessage")
                    .children(".email-success")
                    .remove();
                $("#contact_form_submit #statusMessage").prepend(
                    '<div class="alert alert-danger mt-4 email-success">All Fields are Required.</div>'
                );
                $("#map").height("576px");
                $(".email-success").fadeOut(8000);
            }
        });
    });
})(jQuery);
