<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up() {
        Schema::table('news', function (Blueprint $table) {
            $table->enum('category', ['press_releases', 'interviews'])
                ->default('press_releases')
                ->after('title'); // Adds column after 'title'
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down() {
        Schema::table('news', function (Blueprint $table) {
            $table->dropColumn('category'); // Rollback if needed
        });
    }
};
