<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_additional_info', function (Blueprint $table) {
            $table->string('country_code', 25)->nullable()->after('phone');
            $table->string('flat_no')->nullable()->before('address');
            $table->string('landmark')->nullable()->after('flat_no');
            $table->string('city')->nullable()->after('landmark');
            $table->string('state')->nullable()->after('city');
            $table->string('postal_code')->nullable()->after('state');
            $table->string('country')->nullable()->after('postal_code');
            $table->string('gender')->nullable()->after('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_additional_info', function (Blueprint $table) {
            $table->dropColumn('country_code');
            $table->dropColumn('city');
            $table->dropColumn('state');
            $table->dropColumn('postal_code');
            $table->dropColumn('country');
            $table->dropColumn('gender');
            $table->dropColumn('flat_no');
            $table->dropColumn('landmark');
        });
    }
};
