<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        Schema::dropIfExists('subscribers');

        Schema::create('subscribers', function (Blueprint $table) {
            $table->id();
            $table->string('email');
            $table->tinyInteger('is_subscribe')->default(1)->comment('0: Inactive, 1: Active, 2: Unsubscribe');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscribers');
    }
};
