<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id')->unsigned();
            $table->string('oid', 180);
            $table->string('name', 220);
            $table->string('email', 220);
            $table->string('mobile', 80);
            $table->double('discount', 15, 2)->nullable();
            $table->double('tax', 15, 2)->nullable();
            $table->double('grand_total', 15, 2)->default(0);
            $table->string('status', 80)->default('pending');
            $table->string('payment_status', 80)->default('unpaid');
            $table->text('payment_response')->nullable();
            $table->text('order_response')->nullable();
            $table->text('session_id')->nullable();
            $table->timestamps();


            $table->foreign('user_id')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
