<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_additional_info', function (Blueprint $table) {
            $table->string('phone')->after('address')->nullable();
            $table->string('profile_pic')->after('phone')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_additional_info', function (Blueprint $table) {
            $table->dropColumn('phone');
            $table->dropColumn('profile_pic');
        });
    }
};
