<?php

namespace App\Services;

use Illuminate\Support\Facades\Mail;
use App\Mail\SendDynamicMail;

class EmailService
{
    /**
     * Send an email.
     *
     * @param string $to
     * @param array $data
     * @return void
     */
    public function sendEmail(mixed $to, array $data, string $view, string $subject, mixed $cc = null, mixed $bcc = null): void
    {
        $mail = Mail::to($to);
        if (!empty($cc)) {
            $mail->cc($cc);
        }
        if (!empty($bcc)) {
            $mail->bcc($bcc);
        }
        $mail->send(new SendDynamicMail($data, $view, $subject));
    }
}
