<?php

namespace App\Repositories;

use App\Repositories\Interfaces\UserRepositoryInterface;
use App\Models\User;
use App\Repositories\BaseRepository;
use App\Http\Traits\Bmf;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Hash;


class UserRepository extends BaseRepository
{

    use Bmf;

    protected $model;

    public function __construct(User $_model)
    {
        $this->model = $_model;
    }

    public function __call($method, $args)
    {
        return call_user_func_array([$this->model, $method], $args);
    }

    public function model()
    {
        return UserRepositoryInterface::class;
    }

    public function updateInfo(int $id, array $data)
    {
        $additional = $data['additional'] ?? array();
        $userInputs = $data['user'] ?? array();
        if ($userInputs) {
            $userInputs['name'] =  $userInputs['first_name'] . ' ' . $userInputs['last_name'];
        }
        if (isset($userInputs['password'])) {
            $userInputs['password'] = Hash::make($userInputs['password']);
        }

        if ($id) {
            $user = $this->model->find($id);
            if (empty($user->email_verified_at)) {
                $userInputs['email_verified_at'] = ($userInputs['status'] == '1') ? now() : null;
            }
            $user->update($userInputs);
        } else {
            $user = $this->model->create($userInputs);
        }

        if (isset($additional['profile_pic']) && $additional['profile_pic']) {
            if ($user?->additional_info?->profile_pic) {
                Storage::delete($user->additional_info->profile_pic);
            }
            $imgData = $this->uploadWithFile($data['additional']['profile_pic'], 'uploads/customer_profile');
            $additional['profile_pic'] = $imgData['path'];
        }

        $user->additional_info()->updateOrCreate(['user_id' => $id], $additional);

        return $user;
    }
}
