<?php

namespace App\Repositories;

use App\Repositories\Interfaces\QuestionsRepositoryInterface;
use App\Models\Questions;
use App\Repositories\BaseRepository;

class QuestionsRepository extends BaseRepository
{
    protected $model;

    public function __construct(Questions $_model){
        $this->model = $_model;
    }

    public function __call($method, $args){
        return call_user_func_array([$this->model, $method], $args);
    }

    public function model(){
        return QuestionsRepositoryInterface::class;
    }
}
