<?php

namespace App\Repositories;

use App\Repositories\Interfaces\FAQsRepositoryInterface;
use App\Models\FAQs;
use App\Repositories\BaseRepository;

class FAQsRepository extends BaseRepository
{
    protected $model;

    public function __construct(FAQs $_model){
        $this->model = $_model;
    }

    public function __call($method, $args){
        return call_user_func_array([$this->model, $method], $args);
    }

    public function model(){
        return FAQsRepositoryInterface::class;
    }

}
