<?php

namespace App\Repositories;

use App\Repositories\Interfaces\ContestRepositoryInterface;
use App\Models\Contests;
use App\Repositories\BaseRepository;

class ContestRepository extends BaseRepository
{
    protected $model;

    public function __construct(Contests $_model){
        $this->model = $_model;
    }

    public function __call($method, $args){
        return call_user_func_array([$this->model, $method], $args);
    }

    public function model(){
        return ContestRepositoryInterface::class;
    }

}
