<?php

namespace App\Repositories;

use App\Repositories\Interfaces\ContestImageRepositoryInterface;
use App\Models\ContestImages;
use App\Repositories\BaseRepository;

class ContestImageRepository extends BaseRepository
{
    protected $model;

    public function __construct(ContestImages $_model){
        $this->model = $_model;
    }

    public function __call($method, $args){
        return call_user_func_array([$this->model, $method], $args);
    }

    public function model(){
        return ContestImageRepositoryInterface::class;
    }

}
