<?php

namespace App\Providers;

use Sebdesign\VivaPayments\Enums\WebhookEventType;
use Sebdesign\VivaPayments\Events\WebhookEvent;

class WebhookEventListener
{
    public function handle(WebhookEvent $event): void
    {
        match ($event->EventTypeId) {
            WebhookEventType::TransactionPaymentCreated => $this->transactionPaymentCreated(),
            WebhookEventType::TransactionFailed => $this->transactionFailed(),
            WebhookEventType::TransactionReversalCreated => $this->transactionReversalCreated(),
            default => $this->defaultTransaction(),
        };
    }


    public function transactionPaymentCreated() {}

    public function transactionFailed() {}

    public function transactionReversalCreated() {}

    public function defaultTransaction() {}
}
