<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UsersFavContests extends Model
{
    use HasFactory;

    protected $table    =   "users_fav_contests";

    protected $fillable =   [
        'user_id',
        'contest_id'
    ];

    /**
     * Get the contest that owns the UsersFavContests
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function contest(){
        return $this->belongsTo(Contests::class, 'contest_id', 'id');
    }
}
