<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserCart extends Model
{
    use HasFactory;

    protected $table = 'user_carts';

    protected $fillable = [
        'ip_address',
        'user_id',
        'item_id',
        'quantity',
        'price',
        'total_price'
    ];

    /**
     * Get the item that owns the UserCart
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function item()
    {
        return $this->belongsTo(Contests::class, 'item_id', 'id');
    }
}
