<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserAnswers extends Model
{
    use HasFactory;

    protected $table = "user_answers";

    protected $fillable = [
        'user_id',
        'question_id',
        'answer_id'
    ];

    /**
     * Get the user that owns the UserAnswers
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Get the question that owns the UserAnswers
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function question(){
        return $this->belongsTo(Questions::class, 'question_id');
    }

    /**
     * Get the answer that owns the UserAnswers
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function answer(){
        return $this->belongsTo(QuestionOptions::class, 'answer_id');
    }
}
