<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserAdditionalInfo extends Model
{
    use HasFactory;

    protected $table = 'user_additional_info';

    protected $fillable = [
        'user_id',
        'gender',
        'dob',
        'language',
        'timezone',
        'address',
        'city',
        'state',
        'postal_code',
        'landmark',
        'flat_no',
        'country',
        'iso2',
        'country_code',
        'phone',
        'profile_pic'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
