<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Repositories\Interfaces\UserRepositoryInterface as UserContract;
use Illuminate\Database\Eloquent\Model;
use Spatie\Permission\Traits\HasRoles;
use App\Models\UserCart;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Support\Facades\Crypt;

class User extends Authenticatable implements UserContract
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes,  HasRoles;

    protected $table = 'users';
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'first_name',
        'last_name',
        'email',
        'password',
        'status',
        'provider_name',
        'provider_id',
        'user_type',
        'mobile',
        'email_verified_at',
        'verified_account_token'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'created_at',
        'updated_at',
        'provider_token'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function findByField($requestData)
    {
        return $this->where($requestData);
    }

    public function setProviderTokenAttribute($value)
    {
        return $this->attributes['provider_token'] = Crypt::crypt($value);
    }

    public function getProviderTokenAttribute($value)
    {
        return Crypt::decrypt($value);
    }

    /**
     * Get all of the cart for the User
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function cart()
    {
        return $this->hasMany(UserCart::class, 'user_id', 'id');
    }

    /**
     * Get additoinal info of the User
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */

    public function additional_info(): HasOne
    {
        return $this->hasOne(UserAdditionalInfo::class, 'user_id');
    }

    /* Get all of the favContests for the User
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function favContests()
    {
        return $this->hasMany(UsersFavContests::class, 'user_id', 'id')
            ->leftJoin('contests', 'contests.id', 'users_fav_contests.contest_id')
            ->whereDate('contests.contest_end', '>=', date('Y-m-d'));
    }

    /**
     * Get all of the orders for the User
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function orders()
    {
        return $this->hasMany(Orders::class, 'user_id', 'id');
    }

    /**
     * Get all of the userQuestions for the User
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function userQuestions()
    {
        return $this->hasMany(UserAnswers::class, 'user_id');
    }

    public function userCode()
    {
        return substr($this->name, 0, 2) . $this->id;
    }

    
}
