<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SiteSettings extends Model
{
    use HasFactory;

    protected $table = "site_settings";

    protected $fillable = [
        'title',
        'description',
        'image',
        'mobile',
        'phone',
        'email',
        'type',
        'logo',
        'fav_icon',
        'copyrights',
        'url',
        'link'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function getDetailsByType($type){
        return $this->where('type', $type);
    }
}
