<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrdersTickets extends Model
{
    use HasFactory;

    protected $table = "orders_tickets";

    protected $fillable = [
        'user_id',
        'order_id',
        'item_id',
        'contest_id',
        'ticket_id',
        'ticket_no',
        'ticket_status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    /**
     * Get the order that owns the OrdersItems
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order(){
        return $this->belongsTo(Orders::class, 'order_id');
    }

    /**
     * Get the customer that owns the OrdersItems
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function customer(){
        return $this->belongsTo(User::class, 'user_id');
    }

    public function contest()
    {
        return $this->belongsTo(Contests::class, 'contest_id', 'id');
    }
}
