<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrdersItems extends Model
{
    use HasFactory;

    protected $table = "orders_items";

    protected $fillable = [
        'order_id',
        'contest_id',
        'quantity',
        'price',
        'item_discount',
        'item_tax',
        'total'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    /**
     * Get the order that owns the OrdersItems
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order(){
        return $this->belongsTo(Orders::class, 'order_id');
    }

    /**
     * Get the contest that owns the OrdersItems
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function contest(){
        return $this->belongsTo(Contests::class, 'contest_id');
    }
}
