<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Orders extends Model
{
    use HasFactory;

    protected $table = "orders";

    protected $fillable = [
        'user_id',
        'oid',
        'name',
        'email',
        'mobile',
        'discount',
        'tax',
        'grand_total',
        'status',
        'payment_status',
        'payment_response',
        'order_response',
        'session_id',
        'transaction_id'
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
        'order_response',
        'payment_response'
    ];

    /**
     * Get the user that owns the Orders
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Get all of the items for the Orders
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function items()
    {
        return $this->hasMany(OrdersItems::class, 'order_id', 'id');
    }

    /**
     * Get all of the items for the Orders
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function paymentHistory()
    {
        return $this->hasMany(PaymentHistory::class, 'order_id', 'id');
    }
}
