<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB; // Import DB facade if using Query Builder

class News extends Model
{
    use HasFactory;
    protected $table ="news";

    protected $fillable = [
        'title','category_id', 'image','short_description', 'long_description', 'news_date'
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function AddNewsDetails($Data)
    {
        return self::create($Data);

    }
    public function UpdateNewsDetails($id,$Data)
  {
    return DB::table('news')->where('id',$id)->update($Data);
  }
}
