<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HomePage extends Model
{
    use HasFactory;

    protected $table = 'home_pages';

    protected $fillable = [
        'name',
        'title',
        'sub_title',
        'description',
        'image',
        'key',
        'value',
        'type',
        'reference_id'
    ];

    /**
     * Get all of the moreRelatedData for the HomePage
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function moreRelatedData(){
        return $this->hasMany(HomePage::class, 'reference_id', 'id');
    }
}
