<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FAQCategoriesModel extends Model
{
    use HasFactory;

    protected $table = 'faq_categories';

    protected $fillable = [
        'title',
        'slug',
        'description',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function faqs()
    {
        return $this->hasMany(FAQs::class, 'category', 'id');
    }
}
