<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contests extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'contests';

    protected $fillable = [
        'slug',
        'title',
        'description',
        'price',
        'qty',
        'contest_on',
        'contest_no',
        'overview',
        'specifications',
        'competition_details',
        'contest_number',
        'contest_end',
        'price_type',
        'sort',
        'featured',
        'draw_date',
        'winning_amount',
        'price_delivery'
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * Get all of the images for the Contests
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function images()
    {
        return $this->hasMany(ContestImages::class, 'contest_id', 'id');
    }

    public function remainingContests()
    {
        $query = Contests::leftJoin('orders_items', 'orders_items.contest_id', 'contests.id')
            ->leftJoin('orders', 'orders.id', 'orders_items.order_id')
            ->where('orders_items.contest_id', $this->id)
            ->where('orders.status', 'complete')
            ->get();
        return $query;
    }


    /**
     * Get the order tickets for the contest.
     */
    public function orderTickets()
    {
        return $this->hasMany(OrdersTickets::class, 'contest_id', 'id');
    }

    /**
     * Get the customer details
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function customer()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
