<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AboutUs extends Model
{
    use HasFactory;

    
    protected $table = 'about_us';

    protected $fillable = [
        'name',
        'title',
        'sub_title',
        'description',
        'image',
        'key',
        'value',
        'type',
        'reference_id'
    ];

    /**
     * Get all of the moreRelatedData for the HomePage
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function moreRelatedData(){
        return $this->hasMany(AboutUs::class, 'reference_id', 'id');
    }
}
