<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class SendDynamicMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;
    
    public $template;

    public $subject;
    
    /**
     * Create a new message instance.
     *
     * @param array $data
     * @return void
     */
    public function __construct(array $data, string $template, string $subject)
    {
        $this->data = $data;

        $this->template = $template;

        $this->subject = $subject;
    }


    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view($this->template)
                    ->subject($this->subject)
                    ->with('data', $this->data);
    }
}
