<?php
namespace App\Http\Traits;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use Carbon\Carbon;

trait Bmf{
    
    public function getSessionUser(){

        if(Auth::guard('admin')->check()){
           $user = Auth::guard('admin')->user();
           
        }else{
            $user = null;
        }
        return $user;
    }

    //Generate slug by title and id.
    public function generateSlug($title, $additional=null){
        // Generate a slug from the title
        $slug = Str::slug($title);

        // Optionally, you can append a unique identifier to the slug to ensure uniqueness
        // Example: $slug = Str::slug($title) . '-' . uniqid();

        return $slug;
    }

    public function uploadWithName($request, $fieldName, $directionFolderPath){
        // Process the uploaded file
        $file = $request->file($fieldName);
        if(!$file){
            return null;
        }
        $path = $file->store('public/'.$directionFolderPath);
        $name = $file->getClientOriginalName();
        $extension  = $file->getClientOriginalExtension();

        return [
            'path'      => $path,
            'name'      => $name,
            'extension' => $extension
        ];
    }
    
    public function uploadWithFile($file, $directionFolderPath){
        // Process the uploaded file
        $path = $file->store('public/'.$directionFolderPath);
        $name = $file->getClientOriginalName();
        $extension  = $file->getClientOriginalExtension();

        return [
            'path'      => $path,
            'name'      => $name,
            'extension' => $extension
        ];
    }

    //Single File Upload
    public function uploadFile($request,$inputName,$folderPath)
    {
        $filepath = 'uploads/'.$folderPath.'/';
        if($request->hasfile($inputName) && $_FILES[$inputName]['name'] != ''){
            $file = $request->file($inputName);
            $extension = $file->getClientOriginalExtension();
            $filename = time().'RD'.rand(1,999).'.'.$extension;
            $file->move($filepath,$filename);
            $uploadData = $filepath.$filename;
        }else{
            $uploadData = null;
        }
        return $uploadData;
    }

     //Multi File Upload
    public function multiUploadFiles($request,$inputName,$folderPath){
        $images = [];
        $filePath = 'uploads/'.$folderPath.'/';
        if($request->hasfile($inputName)){
            $files = $request->file($inputName);
            //$allowedFileExtension=['pdf','jpg','png','docx'];
            foreach($files as $k => $file){
                //$filename  = $file->getClientOriginalName();
                $extension = $file->getClientOriginalExtension();
                $fileName = time().'RD'.rand(1,999).'.'.$extension;
                $file->move($filePath, $fileName);
                $images[$k] = $filePath. $fileName;
            }
        }
        return $images;
    }


    public function generateUniqueReferralCode($length = 6){
        $code = Str::random($length);

        // Check if the code already exists
        while (User::where('access_code', $code)->exists()) {
            $code = Str::random($length);
        }

        return $code;
    }

    public function getFilePath($value, $fullPath=false){
        $blank = 'assets/src/images/blank.png';
        $filePath = $fullPath?asset($blank):$blank;
        if(!empty($value) && Storage::exists($value)){
            $filePath = $fullPath?asset(Storage::url($value)):Storage::url($value);
        }
        return $filePath;
    }
}